# 2025-07-07 Triage Log

Busy week. Results are dominated by changes that trade some wins for some losses in small incremental scenarios. We also had a lot of noise and spurious small changes on various PRs. Some regressions come from perf related work where we expect to get some wins back later.

Triage done by **@panstromek**.
Revision range: [ad3b7257..0d11be5a](https://perf.rust-lang.org/?start=ad3b7257615c28aaf8212a189ec032b8af75de51&end=0d11be5aabe0cd49609fff5fce57c4691a22fe55&absolute=false&stat=instructions%3Au)

**Summary**:

Note: We switched to a new benchmark machine at the begining of the period. We show summary based on slightly adjusted range [6988a8fe..8df4a58a](https://perf.rust-lang.org/?start=6988a8fea774a2a20ebebddb7dbf15dd6ef594f9&end=8df4a58ac47b778b093652d6190a6f9d54638774&absolute=false&stat=instructions%3Au) to avoid misleading comparisons from different machines.

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1%  | [0.2%, 4.3%]    | 128   |
| Regressions ❌ <br /> (secondary)  | 1.0%  | [0.2%, 3.9%]    | 84    |
| Improvements ✅ <br /> (primary)   | -3.5% | [-7.2%, -0.2%]  | 48    |
| Improvements ✅ <br /> (secondary) | -5.1% | [-42.6%, -0.2%] | 68    |
| All ❌✅ (primary)                 | -0.2% | [-7.2%, 4.3%]   | 176   |

3 Regressions, 3 Improvements, 11 Mixed; 6 of them in rollups
44 artifact comparisons made in total

#### Regressions

Rollup of 8 pull requests [#143267](https://github.com/rust-lang/rust/pull/143267) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6988a8fea774a2a20ebebddb7dbf15dd6ef594f9&end=f46ce66fcc3d6058f90ac5bf0930f940f1e7b0ca&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.2%, 0.2%] | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.1%, 1.1%] | 18    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.2%, 0.2%] | 1     |

The regressed benchmarks are small and fairly aritifical. Some of the results look like noise and returned to previous state. I don't think this is worth investigating more.

Add new self-profiling event to cheaply aggregate query cache hit counts [#142978](https://github.com/rust-lang/rust/pull/142978) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f51c9870bab634afb9e7a262b6ca7816bb9e940d&end=b94bd12401d26ccf1c3b04ceb4e950b0ff7c8d29&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.1%, 0.4%] | 17    |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.3%, 0.5%] | 7     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.1%, 0.4%] | 17    |

Seems like overhead of the measurement. Pinged the author, but seems like we can't do much about that.

Do not unify borrowed locals in CopyProp. [#143509](https://github.com/rust-lang/rust/pull/143509) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=de031bbcb161b0b7fc0eb16f77b02ce9fbdf4c9e&end=a84ab0ce6c4557a2f01a3a6c3fdb0f92098db78d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.1%, 0.3%]   | 21    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.1%, 1.1%]   | 38    |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.1%  | [-0.4%, 0.3%]  | 23    |

Soundness fix in an mir-opt pass. Posted a comment to make sure these are expected.

#### Improvements

Weekly `cargo update` [#142857](https://github.com/rust-lang/rust/pull/142857) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a413f77285c0ab551cf58db729e054f43150dd50&end=48aee7e383503c234cce4206dee9f19f57edb617&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.9% | [-2.9%, -2.9%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -2.9% | [-2.9%, -2.9%] | 1     |


Allow `enum` and `union` literals to also create SSA values [#138759](https://github.com/rust-lang/rust/pull/138759) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d98a5da813da67eb189387b8ccfb73cf481275d8&end=733b47ea4b1b86216f14ef56e49440c33933f230&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.5%, -0.3%] | 3     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.2%] | 6     |


Canonicalize input ty/ct infer/placeholder in the root universe [#142732](https://github.com/rust-lang/rust/pull/142732) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=175e04331be56c5b4bdf77478434b1a5e0556770&end=5adb489a8034f7b56b29f3b28af0813c866f679c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.8%, -0.3%] | 13    |
| All ❌✅ (primary)                 | -     | -              | 0     |


#### Mixed

Introduce `ByteSymbol` [#141875](https://github.com/rust-lang/rust/pull/141875) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fdad98d7463eebcdca94716ec3036c38a8d66f50&end=6988a8fea774a2a20ebebddb7dbf15dd6ef594f9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.7%  | [1.4%, 2.1%]   | 5     |
| Improvements ✅ <br /> (primary)   | -1.5% | [-6.4%, -0.2%] | 264   |
| Improvements ✅ <br /> (secondary) | -1.9% | [-6.1%, -0.3%] | 298   |
| All ❌✅ (primary)                 | -1.5% | [-6.4%, -0.2%] | 264   |

First PR benchmarked on new machine, these changes are not real as they compare results from different machines. Pre-merge results are much less significant.

Start moving wf checking away from HIR [#142030](https://github.com/rust-lang/rust/pull/142030) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=076a0a26fd6f4c445647a33d6daaac56f732ac05&end=4e973370053a5fe87ee96d43c506623e9bd1eb9d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.3%, 0.6%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.1%, -0.3%] | 8     |
| All ❌✅ (primary)                 | -0.4% | [-0.4%, -0.4%] | 2     |

Marked as triaged by author with comment: Improvements outweigh the regressions. And measured time is improved on the only benchmark that regressed instructions.

Rollup of 11 pull requests [#143338](https://github.com/rust-lang/rust/pull/143338) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6677875279b560442a07a08d5119b4cd6b3c5593&end=25face9808491588e59b6d7844f2185b09eef479&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.3%, 0.4%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.4%]   | 5     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.1%, -0.1%] | 1     |
| All ❌✅ (primary)                 | 0.4%  | [0.3%, 0.4%]   | 2     |

Most of the regressions are probably safe to ignore (small, secondary or noise). The biggest one is in cargo, where the regression is in LLVM, which indicates something probably changed in relation to optmizations or codegen scheduling. Most of the code changes here seem unrelated, though. I suspect it could be one of the standard library changes in first three PRs.

This seems to have returned back to previous state with a little improvement on top in https://github.com/rust-lang/rust/pull/143509, detailed results show inverse numbers on the same LLVM-related queries, but since that PR changed mir optimizations, it probably has some effect on that, too.

Rollup of 6 pull requests [#143363](https://github.com/rust-lang/rust/pull/143363) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9e64506923cb0f18c2bb2b934edecff525774acc&end=a413f77285c0ab551cf58db729e054f43150dd50&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.0%  | [3.0%, 3.0%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.2%] | 11    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-1.1%, -0.2%] | 14    |
| All ❌✅ (primary)                 | -0.0% | [-0.5%, 3.0%]  | 12    |

Already triaged by **@lqd**: The usual clap-derive noise, and it returned to normal on the next merge.

Rollup of 5 pull requests [#143390](https://github.com/rust-lang/rust/pull/143390) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=48aee7e383503c234cce4206dee9f19f57edb617&end=da58c051315268a197ce280f6ba07bbd03c66535&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.0%  | [3.0%, 3.0%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.2%, -0.2%] | 8     |
| All ❌✅ (primary)                 | 3.0%  | [3.0%, 3.0%]   | 1     |

Triaged by **@Kobzol**: `clap_derive` bimodal noise.

MIR inliner maintains unused var_debug_info [#142890](https://github.com/rust-lang/rust/pull/142890) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=da58c051315268a197ce280f6ba07bbd03c66535&end=837c5dd7de03aa97190593aef4e70d53e1bb574b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.8%  | [1.8%, 1.8%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.9% | [-2.9%, -2.9%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.6% | [-2.9%, 1.8%]  | 2     |

`clap_derive` improvement is bimodal noise. `ripgrep` regression doesn't make sense to me. We either do less work or the same amount of work here (not sure which debuginfo option we use for this benchmark). Wall time has no relevant changes, though, so I assume it's spurious.

Avoid depending on forever-red DepNode when encoding metadata. [#143247](https://github.com/rust-lang/rust/pull/143247) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1b61d43bdbf875183b1f436302d62ff93f9a6bba&end=556d20a834126d2d0ac20743b9792b8474d6d03c&stat=instructions:u)

| (instructions:u)                   | mean   | range            | count |
|:----------------------------------:|:------:|:----------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%   | [0.2%, 2.0%]     | 61    |
| Regressions ❌ <br /> (secondary)  | 1.1%   | [0.2%, 2.1%]     | 21    |
| Improvements ✅ <br /> (primary)   | -      | -                | 0     |
| Improvements ✅ <br /> (secondary) | -25.5% | [-42.6%, -16.4%] | 6     |
| All ❌✅ (primary)                 | 0.6%   | [0.2%, 2.0%]     | 61    |

Part of recent metadata related perf work. Regressions are expected and will be investigated in a followup.

Make metadata a workproduct and reuse it [#114669](https://github.com/rust-lang/rust/pull/114669) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0c4fa2690de945f062668acfc36b3f8cfbd013e2&end=e3843659e9f65f589d184d1221ac6149d5fa07b5&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.2%, 2.2%]    | 76    |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.3%, 1.7%]    | 23    |
| Improvements ✅ <br /> (primary)   | -4.3% | [-7.5%, -1.1%]  | 45    |
| Improvements ✅ <br /> (secondary) | -4.9% | [-11.6%, -0.5%] | 36    |
| All ❌✅ (primary)                 | -1.0% | [-7.5%, 2.2%]   | 121   |

Regressions outweigh improvements. Note that lot of the regressions are on very small benchmarks, so the negative effects are somewhat exaggerated. Based on PR description, this change also targets worspace use case that is not represented well in our benchmarks.

Remove `Symbol` from `Named` variant of `BoundRegionKind`/`LateParamRegionKind` [#139598](https://github.com/rust-lang/rust/pull/139598) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=733b47ea4b1b86216f14ef56e49440c33933f230&end=f0b67dd97d74610ee4185cf01c775a563c2017a2&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.1%, 3.2%]   | 13    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.1%, 0.6%]   | 23    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.1%] | 7     |
| All ❌✅ (primary)                 | 0.5%  | [0.1%, 3.2%]   | 13    |

Pre merge results don't match post merge results. Most regressions are in doc benchmarks, impact seems quite low. I left a comment asking for next steps.

Rollup of 6 pull requests [#143507](https://github.com/rust-lang/rust/pull/143507) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=75d5834a6c571cb0455acb5128ad51118fcbf2be&end=febb10d0a2d29278135676783f6a22eb83295981&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.3%]   | 2     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.4%, -0.2%] | 8     |
| All ❌✅ (primary)                 | -     | -              | 0     |

Improvements outweigh regressions, changes are tiny. `coercions` regressions seems to be noise. I don't think this is worth digging into.

Rollup of 6 pull requests [#143521](https://github.com/rust-lang/rust/pull/143521) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e804cd4a5f1a5b658ddca245c80bef96a576c018&end=c83e217d268d25960a0c79c6941bcb3917a6a0af&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.3%]   | 2     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.2% | [-1.9%, -0.0%] | 9     |
| All ❌✅ (primary)                 | 0.2%  | [0.2%, 0.2%]   | 1     |

`coercions` regressions seems to be noise, looks like a new bimodailty. Other changes are tiny, I don't think this is worth investigating.
