// generated by diplomat-tool
import type { DataError } from "./DataError"
import type { DataProvider } from "./DataProvider"
import type { Decimal } from "./Decimal"
import type { DecimalGroupingStrategy } from "./DecimalGroupingStrategy"
import type { Locale } from "./Locale"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * An ICU4X Decimal Format object, capable of formatting a [`Decimal`] as a string.
 *
 * See the [Rust documentation for `DecimalFormatter`](https://docs.rs/icu/latest/icu/decimal/struct.DecimalFormatter.html) for more information.
 */


export class DecimalFormatter {
    get ffiValue(): pointer;


    /**
     * Creates a new [`DecimalFormatter`], using compiled data
     *
     * See the [Rust documentation for `try_new`](https://docs.rs/icu/latest/icu/decimal/struct.DecimalFormatter.html#method.try_new) for more information.
     */
    static createWithGroupingStrategy(locale: Locale, groupingStrategy: DecimalGroupingStrategy | null): DecimalFormatter;

    /**
     * Creates a new [`DecimalFormatter`], using a particular data source.
     *
     * See the [Rust documentation for `try_new`](https://docs.rs/icu/latest/icu/decimal/struct.DecimalFormatter.html#method.try_new) for more information.
     */
    static createWithGroupingStrategyAndProvider(provider: DataProvider, locale: Locale, groupingStrategy: DecimalGroupingStrategy | null): DecimalFormatter;

    /**
     * Creates a new [`DecimalFormatter`] from preconstructed locale data.
     *
     * See the [Rust documentation for `DecimalSymbolsV1`](https://docs.rs/icu/latest/icu/decimal/provider/struct.DecimalSymbolsV1.html) for more information.
     */
    static createWithManualData(plusSignPrefix: string, plusSignSuffix: string, minusSignPrefix: string, minusSignSuffix: string, decimalSeparator: string, groupingSeparator: string, primaryGroupSize: number, secondaryGroupSize: number, minGroupSize: number, digits: Array<codepoint>, groupingStrategy: DecimalGroupingStrategy | null): DecimalFormatter;

    /**
     * Formats a [`Decimal`] to a string.
     *
     * See the [Rust documentation for `format`](https://docs.rs/icu/latest/icu/decimal/struct.DecimalFormatter.html#method.format) for more information.
     */
    format(value: Decimal): string;
}