/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef BUFFER_STREAM_H_
#define BUFFER_STREAM_H_

#include "ByteStream.h"
#include "MediaResource.h"
#include "nsTArray.h"

namespace mozilla {
class MediaByteBuffer;

DDLoggedTypeDeclNameAndBase(BufferStream, ByteStream);

class BufferStream : public ByteStream,
                     public mozilla::DecoderDoctorLifeLogger<BufferStream> {
 public:
  /* BufferStream does not take ownership of aData nor does it make a copy.
   * Therefore BufferStream shouldn't get used after aData is destroyed.
   */
  BufferStream();
  explicit BufferStream(mozilla::MediaByteBuffer* aBuffer);

  virtual nsresult ReadAt(int64_t aOffset, void* aData, size_t aLength,
                          size_t* aBytesRead) override;
  virtual nsresult CachedReadAt(int64_t aOffset, void* aData, size_t aLength,
                                size_t* aBytesRead) override;
  virtual bool Length(int64_t* aLength) override;

  virtual void DiscardBefore(int64_t aOffset) override;

  bool AppendBytes(const uint8_t* aData, size_t aLength);

  mozilla::MediaByteRange GetByteRange();

 private:
  ~BufferStream();
  int64_t mStartOffset;
  RefPtr<mozilla::MediaByteBuffer> mData;
};
}  // namespace mozilla

#endif
